
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MONMISC.H - Miscellaneous User Input Function Prototypes
// 
//
//   DESCRIPTION
//
//   Prototypes for the keystroke processing and user input functions.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Include\Archives\MONMISC.H_V  $
//   
//      Rev 1.15   06 Nov 1998 17:47:22   phungh
//   Labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the write to file code
//   portion out of the interrupt hander so that
//   data is not missed because of time spent
//   too long in the interrupt handler.
//   
//      Rev 1.3   Jul 09 1997 10:28:12   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:04:42   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:28:18   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:54:28   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

short         getval              (char *string, short max);
double        ask_dbl             (char *, double, short *);
float         ask_float           (char *, float, short *);
short         ask_short           (char *, short, short *);
char          ask_char            (char *, char, short *);
void          ask_str             (char *, char *, short *);
short         ask_hex             (char *, short, short *);
long          ask_long            (char *, long, short *);
short         check_disk          (float);
void          clear_message_line  (void);
void          clear_command_line  (void);
void          flush_keys          (void);
short         get_data_file_info  (char *, float *);
KeyboardType  getkey              (short);
void          set_time_with_GPS   (double);
short         store_GPS_time      (float, char *);
unsigned long timer               (void);
